<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package acmfsap
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php global $redux_acmfsap; ?>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'acmfsap'); ?></a>
        <!---
	<header id="masthead" class="site-header">
		<div class="site-branding">
			<?php
            the_custom_logo();
            if (is_front_page() && is_home()) :
            ?>
				<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
				<?php
            else :
                ?>
				<p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
				<?php
            endif;
            $acmfsap_description = get_bloginfo('description', 'display');
            if ($acmfsap_description || is_customize_preview()) :
                ?>
				<p class="site-description"><?php echo $acmfsap_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
                                            ?></p>
			<?php endif; ?>
		</div><!-- .site-branding --

		<nav id="site-navigation" class="main-navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e('Primary Menu', 'acmfsap'); ?></button>
			<?php
            wp_nav_menu(
                array(
                    'theme_location' => 'menu-1',
                    'menu_id'        => 'primary-menu',
                )
            );
            ?>
		</nav><!-- #site-navigation --
	</header><!-- #masthead -->

        <!-- -------------------------------------------------------------- -->
        <!-- Main wrapper - style you can find in pages.scss -->
        <!-- -------------------------------------------------------------- -->
        <div id="main-wrapper">
            <!-- -------------------------------------------------------------- -->
            <!-- Topbar header - style you can find in pages.scss -->
            <!-- -------------------------------------------------------------- -->
            <header class="topbar">
                <nav class="navbar top-navbar navbar-expand-lg navbar-dark">
                    <div class="navbar-header">
                        <!-- This is for the sidebar toggle which is visible on mobile only -->
                        <a class="nav-toggler waves-effect waves-light d-block d-lg-none" href="javascript:void(0)">
                            <i class="ri-close-line fs-6 ri-menu-2-line"></i>
                        </a>
                        <!-- -------------------------------------------------------------- -->
                        <!-- Logo -->
                        <!-- -------------------------------------------------------------- -->
                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                            <!-- Logo icon -->
                            <span class="logo-icon">
                                <img class="light-logo" src="<?php echo $redux_acmfsap['logo']['url']; ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                                <!--You can put here icon as well // <i class="wi wi-sunset"></i> //-->
                                <!-- Dark Logo icon --
                            <img width="100%" src="/wp-content/themes/acmfsap/source/assets/images/logo-icon.png" alt="homepage" class="dark-logo" />
                            <!-- Light Logo icon --
                            <img width="100%" src="/wp-content/themes/acmfsap/source/assets/images/logo-light-icon.png" alt="homepage" class="light-logo" /> -->
                            </span>
                            <!--End Logo icon -->
                            <!-- Logo text -->
                            <span class="logo-text">
                                <strong class="line-1"> <?php echo $redux_acmfsap['header-site-name-row-1']; ?></strong>
                                <strong class="line-2"> <?php echo $redux_acmfsap['header-site-name-row-2']; ?></strong>
                                <strong class="line-3"> <?php echo $redux_acmfsap['header-site-name-row-3']; ?></strong>

                                <!-- dark Logo text --
                            <img width="100%" src="/wp-content/themes/acmfsap/source/assets/images/logo-text.png" alt="homepage" class="dark-logo" />
                            <!-- Light Logo text --
                            <img width="100%" src="/wp-content/themes/acmfsap/source/assets/images/logo-light-text.png" class="light-logo" alt="homepage" />
                            <!-- <b>
                                American Caribbean<br />
                                Maritime Foundation
                            </b>
                            <small>Scholarship Application Portal</small> -->
                            </span>
                        </a>
                        <!-- -------------------------------------------------------------- -->
                        <!-- End Logo -->
                        <!-- -------------------------------------------------------------- -->
                        <!-- -------------------------------------------------------------- -->
                        <!-- Toggle which is visible on mobile only -->
                        <!-- -------------------------------------------------------------- -->
                        <a class="topbartoggler d-block d-lg-none waves-effect waves-light" href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><i class="ri-more-line fs-6"></i></a>
                    </div>
                    <!-- -------------------------------------------------------------- -->
                    <!-- End Logo -->
                    <!-- -------------------------------------------------------------- -->
                    <div class="navbar-collapse collapse" id="navbarSupportedContent">
                        <!-- -------------------------------------------------------------- -->
                        <!-- toggle and nav items -->
                        <!-- -------------------------------------------------------------- -->
                        <ul class="navbar-nav me-auto"></ul>
                        <!-- -------------------------------------------------------------- -->
                        <!-- Right side toggle and nav items -->
                        <!-- -------------------------------------------------------------- -->
                        <ul class="navbar-nav">
                            <?php
                            $section_array = array("Facebook", "Twitter", "YouTube", "LinkedIn");

                            foreach ($section_array as $section) {
                                // if ($redux_acmfsap[$section . '-url'] != "") {
                                echo '
                                    <li class="nav-item">
                                        <a class="nav-link" href="' . $redux_acmfsap[$section . '-url'] . '">
                                            <i class="' . $redux_acmfsap[$section . '-icon'] . '"></i>
                                        </a>
                                    </li>';
                                //}
                            }
                            ?>

                            <!-- -------------------------------------------------------------- -->
                            <!-- User profile and search -->
                            <!-- -------------------------------------------------------------- -->
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle text-muted waves-effect waves-dark pro-pic" href="" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><img src="/wp-content/themes/acmfsap/source/assets/images/users/1.jpg" alt="user" class="rounded-circle" width="31" />
                                </a>
                            </li>
                            <!-- -------------------------------------------------------------- -->
                            <!-- User profile and search -->
                            <!-- -------------------------------------------------------------- -->
                        </ul>
                    </div>
                </nav>
            </header>
            <!-- -------------------------------------------------------------- -->
            <!-- End Topbar header -->
            <!-- -------------------------------------------------------------- -->
            <!-- -------------------------------------------------------------- -->
            <!-- Left Sidebar - style you can find in sidebar.scss  -->
            <!-- -------------------------------------------------------------- -->
            <aside class="left-sidebar">
                <!-- Sidebar scroll-->
                <div class="scroll-sidebar">
                    <!-- Sidebar navigation-->
                    <nav class="sidebar-nav">
                        <ul id="sidebarnav">
                            <!-- User Profile-->
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="/" aria-expanded="false"><i data-feather="home" class="feather-icon"></i><span class="hide-menu">Home
                                    </span></a>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="/applications" aria-expanded="false"><i data-feather="codepen" class="feather-icon"></i><span class="hide-menu">Applications</span></a>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="/account" aria-expanded="false"><i data-feather="cpu" class="feather-icon"></i><span class="hide-menu">Account
                                    </span></a>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="/contact" aria-expanded="false"><i data-feather="file-text" class="feather-icon"></i><span class="hide-menu">Contact</span></a>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="/wp-login.php?action=logout" aria-expanded="false"><i data-feather="file-text" class="feather-icon"></i><span class="hide-menu">Log Out</span></a>
                            </li>
                        </ul>
                    </nav>
                    <!-- End Sidebar navigation -->
                </div>
                <!-- End Sidebar scroll-->
            </aside>
            <!-- -------------------------------------------------------------- -->
            <!-- End Left Sidebar - style you can find in sidebar.scss  -->
            <!-- -------------------------------------------------------------- -->

            <?php if (!is_singular('application')): ?> 
            <!-- -------------------------------------------------------------- --> <!-- -------------------------------------------------------------- -->
            <!-- Page wrapper  -->
            <!-- -------------------------------------------------------------- -->
            <div class="page-wrapper page-breadcrumb-wrap">
                <div class="page-wrapper page-breadcrumb-container">
                    <div class="page-breadcrumb">
                        <!-- -------------------------------------------------------------- -->
                        <!-- Bread crumb and right sidebar toggle -->
                        <!-- -------------------------------------------------------------- -->
                        <div class="row">
                            <div class="col-5 align-self-center">
                                <h4 class="page-title">
                                    <?php
                                    $user_id = get_current_user_id();
                                    $user = get_user_by('id', $user_id);
                                    if ($user->first_name != "") {
                                        echo "Hi, " . $user->first_name;
                                    } else {
                                        echo "Hi there,";
                                    }
                                    ?>
                                    </h4>
                                <div class="d-flex align-items-center">
                                    <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb">
                                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                                            <li class="breadcrumb-item active" aria-current="page">Overview</li>
                                        </ol>
                                    </nav>
                                </div>
                            </div>
                            <div class="col-7 align-self-center">
                                <div class="d-flex no-block justify-content-end align-items-center">
                                    <button type="button" class="btn waves-effect waves-light btn-info large-btn"> Start Your Application </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- -------------------------------------------------------------- -->

            <?php endif; ?>